/* 
 *  MonitoredInteractionRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.MonitoredInteractionNotFoundException;
import com.avaya.ccs.javafxrefclient.MonitoredUserNotFoundException;
import com.avaya.ccs.javafxrefclient.UserNotFoundException;
import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.MonitoredUserI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;
import java.util.List;

public abstract class MonitoredInteractionRequest extends MonitoredUserRequest {

    private final String monitoredInteractionID;

    public MonitoredInteractionRequest(Logger LOG, String supervisorID, String monitoredUserID, String monitoredInteractionID) {
        super(LOG, supervisorID, monitoredUserID);
        this.monitoredInteractionID = monitoredInteractionID;
    }

    /*
    If this methods throws an exeception the base request class will catch it.
     */
    public MonitoredInteractionI getMonitoredInteraction() throws InvalidArgumentException, ObjectInvalidException, UserNotFoundException, MonitoredUserNotFoundException, MonitoredInteractionNotFoundException {
        MonitoredUserI monitoredUser = getMonitoredUser();
        MonitoredInteractionI theMonitoredInteraction = null;

        List<MonitoredInteractionI> monitoredInteractions = monitoredUser.getMonitoredInteractions();
        for (MonitoredInteractionI interaction : monitoredInteractions) {
            if (interaction.getId().equals(monitoredInteractionID)) {
                theMonitoredInteraction = interaction;
            }
        }

        if (theMonitoredInteraction == null) {
            throw new MonitoredInteractionNotFoundException(monitoredInteractionID);
        } else {
            return theMonitoredInteraction;
        }

    }
}
